//================================================================
// * Plugin Name    : spriteEdit
// - Last updated   : 06/08/2024
// - Curent Version : 0.1
//================================================================
/*:
 * @target MZ
 * @plugindesc Edit Sprites for ennemy troop
 * @author Ryuuji
 *
 * @help
 * Plugin Command:
 *   ChangeEnemySprite enemyIndex spriteName
 * 
 * Example:
 *   ChangeEnemySprite 1 Boss_01
 * This will change the sprite of the enemy with the index 1 to use the sprite Boss_01
 *
 * @command ChangeEnemySprite
 * @text Change sprite
 * @desc Change the sprite of an ennemy dynamically
 * 
 * @arg ID
 * @text Ennemy ID
 * @type Number
 * @desc Select the ennemy ID
 * @default 1
 *
 * @arg sprite
 * @text Sprite name
 * @type file
 * @dir img/enemies
 * @desc Select the ennemy sprite to load
 * @default 
 *
 */

 console.log("Running");
(() => {
    const pluginName = 'spriteEdit';

    PluginManager.registerCommand(pluginName, 'ChangeEnemySprite', args => {
        const enemyIndex = Number(args.ID) - 1;
        const spriteName = String(args.sprite);
        const enemy = $gameTroop.members()[enemyIndex];
        if (enemy) {
            if (SceneManager._scene instanceof Scene_Battle) {
                console.log(`Requesting sprite change for enemy ${enemyIndex + 1} to ${spriteName}`);
                SceneManager._scene.requestRefreshEnemySprite(enemy, spriteName);
            }
        }
    });

    const _Scene_Battle_createSpriteset = Scene_Battle.prototype.createSpriteset;
    Scene_Battle.prototype.createSpriteset = function () {
        _Scene_Battle_createSpriteset.call(this);
        this._enemySpriteRefreshRequests = [];
    };

    Scene_Battle.prototype.requestRefreshEnemySprite = function (enemy, spriteName) {
        this._enemySpriteRefreshRequests.push({ enemy, spriteName });
    };

    const _Scene_Battle_update = Scene_Battle.prototype.update;
    Scene_Battle.prototype.update = function () {
        _Scene_Battle_update.call(this);
        if (this._enemySpriteRefreshRequests.length > 0) {
            const requests = this._enemySpriteRefreshRequests.splice(0, this._enemySpriteRefreshRequests.length);
            for (const request of requests) {
                this.refreshEnemySprite(request.enemy, request.spriteName);
            }
        }
    };

    Scene_Battle.prototype.refreshEnemySprite = function (enemy, spriteName) {
        const spriteset = this._spriteset;
        if (spriteset && spriteset._enemySprites) {
            const enemySprite = spriteset._enemySprites.find(sprite => sprite._enemy === enemy);
            if (enemySprite) {
                const bitmap = ImageManager.loadBitmap('img/enemies/', spriteName);
                bitmap.addLoadListener(() => {
                    enemySprite.bitmap = bitmap;
                    enemySprite.setFrame(0, 0, bitmap.width, bitmap.height);
                    enemySprite.updateFrame();
                    if (enemySprite._mainSprite) {
                        enemySprite._mainSprite.bitmap = bitmap;
                        enemySprite._mainSprite.setFrame(0, 0, bitmap.width, bitmap.height);
                    }
                    console.log(`Sprite for enemy updated to ${spriteName}`);
                });
            } else {
                console.log("Enemy sprite not found");
            }
        } else {
            console.log("Spriteset or enemySprites not found");
        }
    };

})();